/*
 * Decompiled with CFR 0.152.
 */
package jclass.cell.editors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import jclass.cell.CellEditor;
import jclass.cell.CellEditorEvent;
import jclass.cell.CellEditorListener;
import jclass.cell.CellEditorSupport;
import jclass.cell.CellInfo;
import jclass.cell.InitialEvent;
import jclass.cell.KeyModifier;
import jclass.cell.ValidateEvent;
import jclass.cell.ValidateInterface;
import jclass.cell.ValidateListener;
import jclass.cell.ValidateSupport;
import jclass.util.JCEnvironment;

public class BaseCellEditor
extends TextField
implements CellEditor,
ValidateInterface,
KeyListener,
MouseListener {
    protected Object data;
    protected int caretPosition;
    protected InitialEvent initialEvent;
    protected CellEditorSupport support = new CellEditorSupport();
    protected boolean selectAll = false;
    protected KeyModifier[] reservedKeys;
    protected ValidateSupport validate_support = new ValidateSupport();

    public BaseCellEditor() {
        this.addKeyListener(this);
        this.addMouseListener(this);
        if (this.reservedKeys == null) {
            this.reservedKeys = new KeyModifier[4];
            this.reservedKeys[0] = new KeyModifier(37);
            this.reservedKeys[1] = new KeyModifier(39);
            this.reservedKeys[2] = new KeyModifier(36);
            this.reservedKeys[3] = new KeyModifier(35);
        }
    }

    public void initialize(InitialEvent initialEvent, CellInfo cellInfo, Object object) {
        this.initialEvent = initialEvent;
        this.data = object;
        this.selectAll = cellInfo.getSelectAll();
        this.setEditable(cellInfo.isEditable());
        if (!this.isEditable()) {
            this.selectAll = false;
        }
        this.caretPosition = initialEvent.getEventType() == 2 && this.data != null ? this.data.toString().length() : -1;
        this.initData();
        this.selectAllText();
        if (JCEnvironment.getOS() == 1 || JCEnvironment.getJavaVersion() == 102) {
            if ((char)initialEvent.getKey() >= ' ' && (char)initialEvent.getKey() <= '~') {
                ((TextComponent)this).setText(String.valueOf(this.getText()) + String.valueOf((char)initialEvent.getKey()));
            } else {
                ((TextComponent)this).setText(this.getText());
            }
            ++this.caretPosition;
        }
        ((Component)this).setBackground(cellInfo.getBackground());
        this.setForeground(cellInfo.getForeground());
    }

    public Component getComponent() {
        return this;
    }

    public Object getCellEditorValue() {
        return this.getText();
    }

    public boolean isModified() {
        if (this.data == null) {
            return this.getCellEditorValue() != null;
        }
        return !this.data.equals(this.getCellEditorValue());
    }

    protected boolean fireValidated(ValidateEvent validateEvent) {
        boolean bl = this.validate_support.fireValidateEvents(validateEvent);
        if (bl) {
            this.show();
        }
        return bl;
    }

    public boolean stopCellEditing() {
        String string = this.getText();
        ValidateEvent validateEvent = new ValidateEvent(this, this.data, string, true);
        return this.fireValidated(validateEvent);
    }

    public void cancelCellEditing() {
        this.initData();
        this.caretPosition = this.data == null ? 0 : this.data.toString().length();
        this.show();
    }

    public Dimension getPreferredSize(CellInfo cellInfo, Object object) {
        return this.preferredSize();
    }

    public KeyModifier[] getReservedKeys() {
        return this.reservedKeys;
    }

    public void show() {
        super.show();
        if (this.caretPosition == -1) {
            String string = this.getText();
            if (this.getFont() == null) {
                return;
            }
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n = 5;
            int n2 = 0;
            while (n2 < string.length()) {
                if ((n += fontMetrics.charWidth(string.charAt(n2))) > this.initialEvent.getX()) break;
                ++n2;
            }
            this.select(n2, n2);
        } else {
            this.caretPosition = Math.min(this.caretPosition, this.getText().length());
            this.select(this.caretPosition, this.caretPosition);
        }
        this.selectAllText();
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.support.addCellEditorListener(cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.support.removeCellEditorListener(cellEditorListener);
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 10: {
                this.support.fireStopEditing(new CellEditorEvent(keyEvent));
                return;
            }
            case 27: {
                this.support.fireCancelEditing(new CellEditorEvent(keyEvent));
                return;
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    void initData() {
        ((TextComponent)this).setText(this.data == null ? "" : this.data.toString());
    }

    public void selectAllText() {
        if (this.selectAll && this.getPeer() != null) {
            try {
                this.setCaretPosition(0);
                this.setCaretPosition(this.data == null ? 0 : this.data.toString().length());
            }
            catch (Exception exception) {}
            this.selectAll();
        }
    }

    public void addValidateListener(ValidateListener validateListener) {
        this.validate_support.addValidateListener(validateListener);
    }

    public void removeValidateListener(ValidateListener validateListener) {
        this.validate_support.removeValidateListener(validateListener);
    }
}

